<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 21.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Neu - Sperrliste');
requireLogin();
requireRole(['Bearbeiter', 'Administrator']);
showSessionAlert();
initializeDatabaseConnection();

if (isset($_POST['createBlacklistEntry'])) {

    $stmt = $pdo->prepare("INSERT INTO BlacklistLocals 
            (Givenname, Surname, Birthday, Nationality, IDCard, Company, Reason, Notes, Created)
            VALUES (:Givenname, :Surname, :Birthday, :Nationality, :IDCard, :Company, :Reason, :Notes, :Created)");

    $stmt->bindParam(':Givenname', $_POST['identityGivenname']);
    $stmt->bindParam(':Surname', $_POST['identitySurname']);
    $stmt->bindParam(':Birthday', $_POST['identityBirthday']);
    $stmt->bindParam(':Nationality', $_POST['identityNationality']);
    $stmt->bindParam(':IDCard', $_POST['identityIDCard']);
    $stmt->bindParam(':Company', $_POST['identityCompany']);
    $stmt->bindParam(':Reason', $_POST['blacklistReason']);
    $stmt->bindParam(':Notes', $_POST['blacklistNotes']);
    $stmt->bindParam(':Created', date('Y-m-d'));
    $stmt->execute();

    // AuditLog: Eintrag erstellen
    addAuditLog($_SESSION['Username'], 'Sperrliste', 'Person "' . $_POST['identityGivenname'] . ' ' . $_POST['identitySurname'] . '" zur Sperrliste hinzugefügt');

    // Erstellt einen Session-Alert 
    createSessionAlert("", "Person " . $_POST['identityGivenname'] . " " . $_POST['identitySurname'] . " zur Sperrliste hinzugefügt", "success", "false", "2000");

    // Verhindert das erneute Absenden des Formulars
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit();
}

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<form action="" method="post" id="newBlacklistEntry" enctype="multipart/form-data">

    <div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
        <div>
            <h4 class="mb-md-0">Neu</h4>
            <span class="text-secondary">Sperrliste</span>
        </div>
        <div class="d-flex align-items-center flex-wrap text-nowrap">

            <button class="btn btn-primary btn-icon-text me-2" type="submit" name="createBlacklistEntry">
                <i class="btn-icon-prepend mdi mdi-plus"></i>
                Hinzufügen
            </button>

            <a href="/identities/blacklist" class="btn btn-secondary btn-icon mb-md-0">
                <i class="mdi mdi-arrow-left-top"></i>
            </a>
        </div>
    </div>

    <div class="row">

        <div class="col-lg-12 col-xl-4 grid-margin">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    Stammdaten
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="identitySurname" class="form-label">Nachname</label>
                        <input id="identitySurname" name="identitySurname" class="form-control" type="text" autofocus>
                    </div>
                    <div class="mb-3">
                        <label for="identityGivenname" class="form-label">Vorname</label>
                        <input id="identityGivenname" name="identityGivenname" class="form-control" type="text">
                    </div>
                    <div class="mb-3">
                        <label for="identityBirthday" class="form-label">Geburtstag</label>
                        <div class="input-group flatpickr" id="flatpickr-date">
                            <input type="date" class="form-control" name="identityBirthday" data-input>
                            <span class="input-group-text input-group-addon" data-toggle><i
                                    data-feather="calendar"></i></span>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Nationalität</label>
                        <select class="js-example-basic-single form-select form-control" name="identityNationality"
                            data-width="100%">
                            <option value="N/A" selected>Keine Auswahl</option>
                            <?php

                            // Datenbankabfrage
                            $sql = "SELECT * FROM SystemNationalities";
                            $stmt = $pdo->query($sql);
                            $Nationalities = $stmt->fetchAll();

                            if ($Nationalities) {
                                foreach ($Nationalities as $Nationality) {
                                    echo '<option value="' . $Nationality['Nationality'] . '">' . $Nationality['Nationality'] . '</option>';
                                }
                            }

                            ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="identityIDCard" class="form-label">Ausweisnummer</label>
                        <input id="identityIDCard" name="identityIDCard" class="form-control" type="text">
                    </div>
                    <div class="mb-3">
                        <label for="identityCompany" class="form-label">Firma</label>
                        <input id="identityCompany" name="identityCompany" class="form-control" type="text">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-12 col-xl-8 grid-margin">

            <div class="card grid-margin">
                <div class="card-header bg-warning text-white">
                    Begründung
                </div>
                <div class="card-body">
                    <textarea class="form-control" name="blacklistReason" id="blacklistReasonMDE" rows="8"></textarea>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    Notizen
                </div>
                <div class="card-body">
                    <textarea class="form-control" name="blacklistNotes" id="blacklistNotesMDE" rows="5"></textarea>
                </div>
            </div>

        </div>

    </div>

</form>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>